/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp;

import DE.siemens.ad.logo.app.comp.BorderJPanel;
import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.app.comp.EditableNumericSpinner;
import DE.siemens.ad.logo.app.comp.NumericSpinnerListener;
import DE.siemens.ad.logo.dialog.comp.SpinnerChangedEvent;
import DE.siemens.ad.logo.model.MessageManager;
import DE.siemens.ad.logo.model.block.MessageBlock;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoError;
import DE.siemens.ad.logo.util.MessageGlobalInfo;
import DE.siemens.ad.logo.util.ProgramException;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageGlobalSettingPanel
extends DataInputPanel {
    private static final long serialVersionUID = 1L;
    private MessageGlobalInfo fModel = null;
    private JPanel fMessageGeneral = null;
    private JLabel fMessageLangLabel1 = null;
    private JComboBox fMessageLang1 = null;
    private JLabel fMessageLangLabel2 = null;
    private JComboBox fMessageLang2 = null;
    private JLabel fAnalogInputFilterLabel;
    private JPanel fAnalogInputFilterPanel;
    private JComboBox fAnalogInputFilter;
    private BorderJPanel fTickerTimer = null;
    private LogoDrawing fLogoDrawing = null;
    private Hashtable<String, String> filterTimer = new Hashtable();
    private static Hashtable<String, String> convertFilterTimer = new Hashtable();
    private EditableNumericSpinner cTickerTimer = null;
    private EditableNumericSpinner lTickerTimer = null;
    private JLabel cTickerTimerLabel = null;
    private JLabel lTickerTimerLabel = null;
    private Dimension fPageDimension = null;
    private int fCurCharSetID = 0;
    private ButtonGroup buttonGroup = null;
    private JRadioButton radioButton1 = null;
    private JRadioButton radioButton2 = null;
    private JTextArea character1;
    private JTextArea character2;
    private BorderJPanel infoPanel;
    private BorderJPanel defaultSettingPanel = null;
    private BorderJPanel langBorderPanel = null;
    private JCheckBox useNewFeature = null;
    private JCheckBox useAsDefault = null;

    public MessageGlobalSettingPanel(LogoDrawing logoDrawing) {
        this.fModel = logoDrawing.getWiringDiagram().getMessageGlobalInfo();
        this.fLogoDrawing = logoDrawing;
        this.initialize();
    }

    private void initialize() {
        this.filterTimer.put("1", "100");
        this.filterTimer.put("2", "200");
        this.filterTimer.put("4", "400");
        this.filterTimer.put("8", "800");
        this.filterTimer.put("10", "1000");
        this.setName(Language.getString("dialog.parameter.message.menu.title", "Message Text Setting"));
        this.setBounds(0, 0, 600, 400);
        this.setLayout(this.getPropertyPanelBorderLayout());
        this.setSize(562, 400);
        this.add((Component)this.getGeneral(), "Center");
    }

    private JPanel getGeneral() {
        if (this.fMessageGeneral == null) {
            try {
                this.fMessageGeneral = new JPanel();
                this.fMessageGeneral.setLayout(new GridBagLayout());
                this.fMessageGeneral.setVisible(true);
                this.fMessageGeneral.setMinimumSize(new Dimension(0, 0));
                GridBagConstraints constraintstDefaultPanel = new GridBagConstraints();
                constraintstDefaultPanel.gridx = 0;
                constraintstDefaultPanel.gridy = 0;
                constraintstDefaultPanel.gridheight = 4;
                constraintstDefaultPanel.gridwidth = 3;
                constraintstDefaultPanel.fill = 2;
                constraintstDefaultPanel.anchor = 17;
                constraintstDefaultPanel.insets = new Insets(4, 4, 4, 4);
                this.fMessageGeneral.add((Component)this.getDefaultSettingPanel(), constraintstDefaultPanel);
                GridBagConstraints constraintstTickerTimer = new GridBagConstraints();
                constraintstTickerTimer.gridx = 0;
                constraintstTickerTimer.gridy = 4;
                constraintstTickerTimer.gridheight = 2;
                constraintstTickerTimer.gridwidth = 3;
                constraintstTickerTimer.fill = 2;
                constraintstTickerTimer.anchor = 17;
                constraintstTickerTimer.insets = new Insets(4, 4, 4, 4);
                this.fMessageGeneral.add((Component)this.getTickerTimer(), constraintstTickerTimer);
                GridBagConstraints constraintstAnalogLabel = new GridBagConstraints();
                constraintstAnalogLabel.gridx = 0;
                constraintstAnalogLabel.gridy = 6;
                constraintstAnalogLabel.anchor = 17;
                constraintstAnalogLabel.insets = new Insets(4, 4, 4, 2);
                this.fMessageGeneral.add((Component)this.getAnalogInputFilterPanel(), constraintstAnalogLabel);
                GridBagConstraints constraintstInfo = new GridBagConstraints();
                constraintstInfo.gridx = 0;
                constraintstInfo.gridy = 7;
                constraintstInfo.gridwidth = 3;
                constraintstInfo.gridheight = 6;
                constraintstInfo.fill = 3;
                constraintstInfo.anchor = 17;
                constraintstInfo.insets = new Insets(4, 4, 4, 4);
                this.fMessageGeneral.add((Component)this.getInfoPanel(), constraintstInfo);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.fMessageGeneral;
    }

    private JPanel getInfoPanel() {
        if (null == this.infoPanel) {
            this.infoPanel = new BorderJPanel(new BorderLayout());
            this.infoPanel.setTitle(Language.getString("dialog.parameter.message.menu.supportingLanguage", "Supporting Language"));
            this.character1 = new JTextArea();
            this.character1.setLineWrap(true);
            this.character1.setWrapStyleWord(true);
            this.character1.setEditable(false);
            this.character1.setBackground(this.infoPanel.getBackground());
            this.character1.setColumns(38);
            this.character1.setRows(2);
            this.character2 = new JTextArea();
            this.character2.setLineWrap(true);
            this.character2.setWrapStyleWord(true);
            this.character2.setBackground(this.infoPanel.getBackground());
            this.character2.setColumns(38);
            this.character2.setEditable(false);
            this.character2.setRows(2);
            this.infoPanel.add((Component)this.character1, "North");
            this.infoPanel.add((Component)this.character2, "Center");
        }
        return this.infoPanel;
    }

    private BorderJPanel getTickerTimer() {
        if (this.fTickerTimer == null) {
            try {
                this.fTickerTimer = new BorderJPanel(new GridLayout(2, 1));
                this.fTickerTimer.setTitle(Language.getString("dialog.parameter.message.menu.setMessageTickerTimer", "Ticker Timer Setting"));
                this.cTickerTimer = new EditableNumericSpinner();
                this.cTickerTimer.setName("cTickerTimer");
                this.cTickerTimer.setMinMax(100, 10000);
                this.cTickerTimer.setIncrement(100);
                this.cTickerTimerLabel = new JLabel();
                this.cTickerTimerLabel.setText(Language.getString("dialog.parameter.message.tickerType0", "Character by character"));
                this.lTickerTimer = new EditableNumericSpinner();
                this.lTickerTimer.setName("lTickerTimer");
                this.lTickerTimer.setMinMax(1000, 100000);
                this.lTickerTimer.setIncrement(1000);
                this.lTickerTimer.setEnabled(false);
                this.lTickerTimerLabel = new JLabel();
                this.lTickerTimerLabel.setText(Language.getString("dialog.parameter.message.tickerType1", "Line by line"));
                JLabel cTimeUnit = new JLabel(Language.getString("dialog.parameter.message.menu.tickerTimeUnit", "ms"));
                JLabel lTimeUnit = new JLabel(Language.getString("dialog.parameter.message.menu.tickerTimeUnit", "ms"));
                JPanel cPanel = new JPanel(new FlowLayout(0));
                cPanel.add(this.cTickerTimerLabel);
                cPanel.add(this.cTickerTimer);
                cPanel.add(cTimeUnit);
                JPanel lPanel = new JPanel(new FlowLayout(0));
                lPanel.add(this.lTickerTimerLabel);
                lPanel.add(this.lTickerTimer);
                lPanel.add(lTimeUnit);
                this.fTickerTimer.add(cPanel);
                this.fTickerTimer.add(lPanel);
                this.cTickerTimer.addNumericSpinnerListener(new NumericSpinnerListener(){

                    public void spinnerChanged(SpinnerChangedEvent se) {
                        MessageGlobalSettingPanel.this.lTickerTimer.setValue(MessageGlobalSettingPanel.this.cTickerTimer.getValue() * 10);
                    }
                });
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.fTickerTimer;
    }

    private JPanel getAnalogInputFilterPanel() {
        if (this.fAnalogInputFilterPanel == null) {
            this.fAnalogInputFilterPanel = new JPanel();
            this.fAnalogInputFilterLabel = new JLabel();
            this.fAnalogInputFilterLabel.setText(Language.getString("dialog.parameter.message.menu.setMessageAnalogTimer", "Analog input filter timer"));
            String[] value = new String[]{"100", "200", "400", "800", "1000"};
            this.fAnalogInputFilter = new JComboBox<String>(value);
            this.fAnalogInputFilter.setName("AnalogInputFilter");
            JLabel timeUnit = new JLabel(Language.getString("dialog.parameter.message.menu.tickerTimeUnit", "ms"));
            this.fAnalogInputFilterPanel.add(this.fAnalogInputFilterLabel);
            this.fAnalogInputFilterPanel.add(this.fAnalogInputFilter);
            this.fAnalogInputFilterPanel.add(timeUnit);
        }
        return this.fAnalogInputFilterPanel;
    }

    private JLabel getMessageLangLabel1() {
        if (this.fMessageLangLabel1 == null) {
            try {
                this.fMessageLangLabel1 = new JLabel();
                this.fMessageLangLabel1.setText(Language.getString("dialog.parameter.message.menu.setMessageLanguageLabel1", "Character Set 1:"));
                this.fMessageLangLabel1.setLocation(new Point(8, 27));
                this.fMessageLangLabel1.setMaximumSize(new Dimension(45, 17));
                this.fMessageLangLabel1.setBounds(new Rectangle(8, 27, 120, 15));
                this.fMessageLangLabel1.setMinimumSize(new Dimension(45, 17));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.fMessageLangLabel1;
    }

    private JComboBox getMessageLang1() {
        if (this.fMessageLang1 == null) {
            try {
                this.fMessageLang1 = new JComboBox();
                this.fMessageLang1.setName("tLangID1");
                this.fMessageLang1.setLocation(new Point(140, 23));
                this.fMessageLang1.setBounds(new Rectangle(140, 23, 247, 19));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.fMessageLang1;
    }

    private JLabel getMessageLangLabel2() {
        if (this.fMessageLangLabel2 == null) {
            try {
                this.fMessageLangLabel2 = new JLabel();
                this.fMessageLangLabel2.setLocation(new Point(8, 27));
                this.fMessageLangLabel2.setText(Language.getString("dialog.parameter.message.menu.setMessageLanguageLabel2", "Character Set 2:"));
                this.fMessageLangLabel2.setMaximumSize(new Dimension(45, 17));
                this.fMessageLangLabel2.setBounds(new Rectangle(8, 27, 120, 15));
                this.fMessageLangLabel2.setMinimumSize(new Dimension(45, 17));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.fMessageLangLabel2;
    }

    private JComboBox getMessageLang2() {
        if (this.fMessageLang2 == null) {
            try {
                this.fMessageLang2 = new JComboBox();
                this.fMessageLang2.setName("tLangID2");
                this.fMessageLang2.setLocation(new Point(140, 23));
                this.fMessageLang2.setBounds(new Rectangle(140, 23, 247, 19));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.fMessageLang2;
    }

    private BorderLayout getPropertyPanelBorderLayout() {
        BorderLayout ivjPropertyPanelBorderLayout = null;
        try {
            ivjPropertyPanelBorderLayout = new BorderLayout();
            ivjPropertyPanelBorderLayout.setVgap(0);
            ivjPropertyPanelBorderLayout.setHgap(0);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        return ivjPropertyPanelBorderLayout;
    }

    private void handleException(Throwable exception) {
        exception.printStackTrace();
    }

    @Override
    public void loadFieldContents() throws ProgramException {
        this.loadLanguageComboBox();
        this.useNewFeature.setSelected(this.fModel.isFUseNewFeature());
        this.updateComponentEnabledStatus(this.useNewFeature.isSelected());
        if (this.fModel.isFUseNewFeature()) {
            this.fCurCharSetID = this.fModel.getCurCharSetID();
            if (1 == this.fCurCharSetID) {
                this.radioButton2.setSelected(true);
            } else {
                this.radioButton1.setSelected(true);
            }
            this.fMessageLang1.setSelectedItem(MessageGlobalInfo.getCharSetName(this.fModel.getSelectedCharSet(0)));
            this.fMessageLang2.setSelectedItem(MessageGlobalInfo.getCharSetName(this.fModel.getSelectedCharSet(1)));
            this.character1.setText(MessageGlobalInfo.getSupportedLanguage(this.fModel.getSelectedCharSet(0)));
            this.character2.setText(MessageGlobalInfo.getSupportedLanguage(this.fModel.getSelectedCharSet(1)));
        }
        this.fAnalogInputFilter.setSelectedItem(this.filterTimer.get(new Integer(this.fModel.getAnalogRefreshInterval()).toString()));
        this.cTickerTimer.setValue(this.fModel.getTickerInterval() * 100);
        this.lTickerTimer.setValue(this.fModel.getTickerInterval() * 1000);
    }

    @Override
    public String getHelpIdString() {
        return "file.messagetextsettings";
    }

    @Override
    public void storeFieldContents() {
        int lang1 = MessageGlobalInfo.getCharSetKey(this.fMessageLang1.getSelectedItem().toString());
        int lang2 = MessageGlobalInfo.getCharSetKey(this.fMessageLang2.getSelectedItem().toString());
        if (this.fModel.isFUseNewFeature() != this.useNewFeature.isSelected()) {
            this.fModel.setFUseNewFeature(this.useNewFeature.isSelected());
            if (this.fModel.isFUseNewFeature()) {
                this.getMsgManager().transferToRTF(lang1);
            } else {
                this.getMsgManager().transferToPlain();
            }
        } else if (this.fModel.isFUseNewFeature()) {
            if (this.fModel.getSelectedCharSet(0) != lang1) {
                this.getMsgManager().transferContentsToCharset(0, MessageGlobalInfo.getCharSetKey(this.fMessageLang1.getSelectedItem().toString()));
            }
            if (this.fModel.getSelectedCharSet(1) != lang2) {
                this.getMsgManager().transferContentsToCharset(1, MessageGlobalInfo.getCharSetKey(this.fMessageLang2.getSelectedItem().toString()));
            }
        }
        this.fModel.setSelectedCharSets(lang1, 0);
        this.fModel.setSelectedCharSets(lang2, 1);
        if (this.radioButton1.isSelected()) {
            this.fModel.setCurCharSet(0);
        } else {
            this.fModel.setCurCharSet(1);
        }
        this.fModel.setAnalogRefreshInterval(new Integer(this.getConvertFilterTimer().get(this.fAnalogInputFilter.getSelectedItem())));
        this.fModel.setTickerInterval(this.cTickerTimer.getValue() / 100);
        if (this.useAsDefault.isSelected()) {
            this.fModel.saveAsDefault();
        }
        this.fLogoDrawing.setModified(true);
        this.updateDrawing();
    }

    private Hashtable<String, String> getConvertFilterTimer() {
        if (convertFilterTimer.isEmpty()) {
            Enumeration<String> keyOfFilterTimer = this.filterTimer.keys();
            while (keyOfFilterTimer.hasMoreElements()) {
                String key = keyOfFilterTimer.nextElement();
                convertFilterTimer.put(this.filterTimer.get(key), key);
            }
        }
        return convertFilterTimer;
    }

    private void updateDrawing() {
        MessageBlock[] blocks = this.getMsgManager().getMessageBlocks();
        for (int i = 0; i < blocks.length; ++i) {
            blocks[i].getParameter().fireParameterSetEvent();
        }
    }

    @Override
    public boolean checkChanged() {
        return this.getMessageLang1().getSelectedItem() != null && this.fModel.getSelectedCharSet(0) == MessageGlobalInfo.getCharSetKey(this.getMessageLang1().getSelectedItem().toString()) || this.getMessageLang2().getSelectedItem() != null && this.fModel.getSelectedCharSet(1) == MessageGlobalInfo.getCharSetKey(this.getMessageLang2().getSelectedItem().toString()) || this.fAnalogInputFilter.getSelectedItem() != null && !new Integer(this.fModel.getTickerInterval()).toString().equals(this.filterTimer.get(this.fAnalogInputFilter.getSelectedItem())) || this.fModel.getTickerInterval() * 100 != this.cTickerTimer.getValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean checkFieldContents() {
        if (!this.cTickerTimer.checkValue(true)) {
            return false;
        }
        if (this.fAnalogInputFilter.getSelectedItem() == null) {
            return false;
        }
        if (this.fMessageLang1.getSelectedItem() == null) {
            return false;
        }
        int lang1 = MessageGlobalInfo.getCharSetKey(this.fMessageLang1.getSelectedItem().toString());
        if (this.fMessageLang2.getSelectedItem() == null) {
            return false;
        }
        int lang2 = MessageGlobalInfo.getCharSetKey(this.fMessageLang2.getSelectedItem().toString());
        if (this.fModel.isFUseNewFeature() != this.useNewFeature.isSelected()) {
            if (this.useNewFeature.isSelected()) return true;
            if (!this.comfirmContentsDeletion()) return false;
            if (this.confirmDestTickerSettingMissing()) return true;
            return false;
        }
        if (!this.fModel.isFUseNewFeature() || this.fModel.getSelectedCharSet(0) == lang1 && this.fModel.getSelectedCharSet(0) == lang2 || this.comfirmContentsDeletion()) return true;
        return false;
    }

    private boolean confirmDestTickerSettingMissing() {
        LogoError dlg = new LogoError((Component)this.fMessageGeneral, "dialog.parameter.message.menu.clearDestTickInfo", "The Destination and Ticker settings will be lost. \nDo you want to continue?", 2, 2);
        dlg.setHelpKey("block.Message");
        return dlg.display() == 2;
    }

    private boolean comfirmContentsDeletion() {
        LogoError dlg = new LogoError((Component)this.fMessageGeneral, "dialog.parameter.message.menu.clearMsgContents", "Some Message contents will be removed!\nAre you sure to do that?", 2, 2);
        dlg.setHelpKey("block.Message");
        return dlg.display() == 2;
    }

    public Dimension getPageDimension() {
        if (this.fPageDimension == null) {
            this.fPageDimension = new Dimension(60, 40);
        }
        return this.fPageDimension;
    }

    public void activateParameterTab() {
    }

    private BorderJPanel getDefaultSettingPanel() {
        if (this.defaultSettingPanel == null) {
            this.defaultSettingPanel = new BorderJPanel(new BorderLayout());
            this.buttonGroup = new ButtonGroup();
            this.radioButton1 = new JRadioButton(Language.getString("dialog.parameter.message.menu.setMessageDefaultLabel", "Default"));
            this.radioButton2 = new JRadioButton(Language.getString("dialog.parameter.message.menu.setMessageDefaultLabel", "Default"));
            this.buttonGroup.add(this.radioButton1);
            this.buttonGroup.add(this.radioButton2);
            this.useNewFeature = new JCheckBox();
            this.useNewFeature.setText(Language.getString("dialog.parameter.message.menu.setMessageFeature", "Use new feature"));
            this.useNewFeature.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MessageGlobalSettingPanel.this.updateComponentEnabledStatus(MessageGlobalSettingPanel.this.useNewFeature.isSelected());
                }
            });
            this.useAsDefault = new JCheckBox();
            this.useAsDefault.setText(Language.getString("dialog.format.default", "Use as default"));
            this.langBorderPanel = new BorderJPanel(new GridLayout(2, 3));
            this.langBorderPanel.setTitle(Language.getString("dialog.parameter.message.menu.setMessageLanguageString", "Language setting"));
            this.langBorderPanel.add(this.getMessageLangLabel1());
            this.langBorderPanel.add(this.getMessageLang1());
            this.langBorderPanel.add(this.radioButton1);
            this.langBorderPanel.add(this.getMessageLangLabel2());
            this.langBorderPanel.add(this.getMessageLang2());
            this.langBorderPanel.add(this.radioButton2);
            this.defaultSettingPanel.add((Component)this.useNewFeature, "North");
            this.defaultSettingPanel.add((Component)this.langBorderPanel, "Center");
            this.defaultSettingPanel.add((Component)this.useAsDefault, "South");
        }
        return this.defaultSettingPanel;
    }

    private MessageManager getMsgManager() {
        return this.fLogoDrawing.getWiringDiagram().getMessageManager();
    }

    private void loadLanguageComboBox() {
        this.fMessageLang1.setModel(new DefaultComboBoxModel<String>(this.fModel.getCharSetListAvailable()));
        this.fMessageLang2.setModel(new DefaultComboBoxModel<String>(this.fModel.getCharSetListAvailable()));
    }

    private void updateComponentEnabledStatus(boolean useNewFeature) {
        this.fMessageLang1.setSelectedItem("ISO_8859_1");
        this.fMessageLang2.setSelectedItem("ISO_8859_1");
        this.radioButton1.setEnabled(useNewFeature);
        this.radioButton2.setEnabled(useNewFeature);
        this.fMessageLang1.setEnabled(useNewFeature);
        this.fMessageLang2.setEnabled(useNewFeature);
        if (useNewFeature) {
            this.character1.setText(MessageGlobalInfo.getSupportedLanguage(this.fMessageLang1.getSelectedItem().toString()));
            this.character2.setText(MessageGlobalInfo.getSupportedLanguage(this.fMessageLang2.getSelectedItem().toString()));
        } else {
            this.character1.setText("");
            this.character2.setText("");
            this.radioButton1.setSelected(true);
        }
    }
}

